#pragma once

#include "dm_lnx_Protocol.h"

//..............................................................................

size_t
getWriteProtectionBackupSize(
	const void* begin,
	const void* end
);

void
disablePreemptionAndWriteProtection(
	const void* begin,
	const void* end,
	void* backup,
	size_t backupSize
);

void
restoreWriteProtectionAndPreemption(
	const void* begin,
	const void* end,
	const void* backup,
	size_t backupSize
);

// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .

char*
createPathString(const struct path* path);

char*
copyStringFromUser(const dm_String __user* string_u);

int
copyStringToUser(
	dm_String __user* string_u,
	const char* p
);

uint64_t
getTimestamp(void);

struct module*
getOwnerModule(struct file* filp);

//..............................................................................
